/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

 /**
 * \file    uart_test.c
 *
 * \brief   This file contains support routines to test uart. 
 *
 * This file contains support routines to test uart 
 * 
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

#include "dm388_types.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "uart.h"

#define SIZE 10

 static UINT8 rx[SIZE+1];
 static UINT8 tx[]="\n\rDM388 UART Test!\n\r";
 static UINT8 msg[]="\n\rEnter 10 Characters Here:";
 static UINT8 echoMsg[]="\n\rCharacters Received:";
 static INT32 uart_timeout = ( 0x00800000 );

static INT16 uart_send_string(UART_Handle uart, UINT8 *buf, UINT32 length)
{
	UINT32 index;
	INT16 ret;

    for (index = 0; index < length; index++)
    {
        ret = uart_send(uart, buf[index], uart_timeout );
    	if (ret != 0)
    	{
                //An error occured
    			platform_write("UART TX error\n");
    			return -1;
    	}
    }

    return 0;
}

static INT16 uart_receive_string(UART_Handle uart, UINT8 *buf, UINT32 length)
{
	UINT32 index;
	INT16 ret;

	for (index = 0; index < length; index++)
   	{
        ret = uart_recv(uart, &buf[index], uart_timeout);  // RX
        if (ret != 0)
        {
           platform_write("UART RX error\n");
           return -1;
        }
    }

    return 0;
}


 /** **************************************************************************
 * \n \brief Routine to do uart_loopback_test
 *
 * This routine does uart_loopback_test.This routine transmits a buffer of size  
 * 256 bytes and receives the same and compares both the buffer .Returns 0 on
 * success.
 * 
 * \return        
 * \n        returns Non-Zero value on failure                                        
 * \n        returns zero success
 *  
 * 
 */

INT16 uart_loopback_test( )
{
    INT16 ret;
    INT16 msgSize;
    UART_Handle uart2;
    
    /* Open Uart Handle */
    if ( ( uart2 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
        return -1;

    msgSize = strlen((const char*)tx);
    ret = uart_send_string(uart2, tx, msgSize);
	if (ret != 0)
	{
		return ret;
	}

    msgSize = strlen((const char*)msg);
    ret = uart_send_string(uart2, msg, msgSize);
	if (ret != 0)
	{
		return ret;
	}

	ret = uart_receive_string(uart2, rx, SIZE);
	if (ret != 0)
	{
		return ret;
	}

	rx[SIZE] = '\0';

	platform_write("Received Data on UART - %s\n", rx);
	platform_write("Sending the Data Back to Tx\n");

    msgSize = strlen((const char*)echoMsg);
    ret = uart_send_string(uart2, echoMsg, msgSize);
	if (ret != 0)
	{
		return ret;
	}

    ret = uart_send_string(uart2, rx, SIZE);
	if (ret != 0)
	{
		return ret;
	}

	platform_write("\nUART Test Complete!\n");

    return 0;
}
